/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.api.security.User;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.wsi.WSICredential;
import filenet.pe.peorb.client.UserPasswordCallbackHandler;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class JAASContext {
    static final String m_className = "JAASContext";
    protected static final Logger logger = Logger.getLogger("filenet.pe.peorb.client");
    private String m_username;
    private String m_domain;
    private Subject m_subject;
    private String m_subjectAsString;
    private String m_origUserName;
    private String m_ceURI;

    public static String _get_FILE_DATE() {
        return "20110826";
    }

    public static String _get_FILE_REVISION() {
        return "dts969203-scm969808";
    }

    private static String printPW(String pw) {
        int len = pw == null ? 0 : pw.length();
        char[] x = new char[len];
        for (int i = 0; i < len; ++i) {
            x[i] = 42;
        }
        return new String(x);
    }

    public JAASContext(Subject mySubject, String ceURI) {
        block12: {
            this.m_username = "";
            this.m_domain = "";
            this.m_subject = null;
            this.m_subjectAsString = null;
            this.m_origUserName = null;
            this.m_ceURI = null;
            this.m_ceURI = ceURI;
            this.m_subject = mySubject;
            String string = this.m_subjectAsString = mySubject == null ? "NOSUBJECT" : mySubject.toString();
            if (this.m_subject == null) {
                return;
            }
            String m_method = "ctor:" + this.m_subjectAsString;
            try {
                Principal[] p = mySubject.getPrincipals().toArray(new Principal[0]);
                if (p == null || p.length == 0) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, " has no Principals yet...");
                    }
                    if ((p = mySubject.getPrivateCredentials().toArray(new Principal[0])) != null && p.length > 0) {
                        for (Principal o : p) {
                            if (!(o instanceof WSICredential)) continue;
                            WSICredential cred = (WSICredential)o;
                            this.m_username = cred.getSecurityToken().UsernameToken.Username;
                            String pw = cred.getSecurityToken().UsernameToken.Password;
                            if (logger.isFinest()) {
                                logger.finest(m_className, m_method, "WSI credentials username=" + this.m_username + ", " + JAASContext.printPW(pw));
                            }
                            break;
                        }
                    }
                } else {
                    Principal m_principal = p[0];
                    this.m_username = m_principal.getName();
                    int slashOffset = this.m_username.indexOf("/");
                    if (slashOffset > 0) {
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "username=" + this.m_username + ", adjusting because of slash character");
                        }
                        this.m_username = this.m_username.substring(slashOffset + 1);
                    }
                    this.m_domain = "";
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "principal=" + m_principal + ", username=" + this.m_username);
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isFinest()) break block12;
                logger.finest(m_className, m_method, "Exception: " + e);
            }
        }
    }

    public String toString() {
        return this.m_subjectAsString;
    }

    protected String getUserName() {
        return this.m_username;
    }

    private void setUserName(String s) {
        this.m_origUserName = this.m_username;
        this.m_username = s;
    }

    protected String getOrigUserName() {
        return this.m_origUserName;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public Subject getSubject() {
        return this.m_subject;
    }

    public int hashCode() {
        if (this.m_subject == null) {
            return super.hashCode();
        }
        return this.m_subject.hashCode();
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        if (!(another instanceof JAASContext)) {
            return false;
        }
        JAASContext anotherJAASContext = (JAASContext)another;
        if (this.m_subject == null || anotherJAASContext.getSubject() == null) {
            return false;
        }
        return this.m_subject.equals(anotherJAASContext.getSubject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkShortName(String tokenName) {
        String m_method = "checkShortName:" + this.m_username + "," + tokenName;
        if (this.m_username != null && this.m_username.compareToIgnoreCase(tokenName) == 0) {
            return;
        }
        Principal[] principals = this.m_subject.getPrincipals().toArray(new Principal[0]);
        if (principals != null && principals.length > 0) {
            for (Principal p : principals) {
                String pName = p.getName();
                if (pName == null || 0 != pName.compareToIgnoreCase(tokenName)) continue;
                this.setUserName(tokenName);
                return;
            }
        }
        UserContext old = UserContext.get();
        try {
            UserContext uc = new UserContext();
            UserContext.set((UserContext)uc);
            uc.pushSubject(this.getSubject());
            User user = Factory.User.fetchCurrent((Connection)Factory.Connection.getConnection((String)this.m_ceURI), null);
            String dn = user.get_DistinguishedName();
            String shortname = user.get_ShortName();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "ShortName=" + shortname + ", DistinguishedName=" + dn);
            }
            if (0 == shortname.compareToIgnoreCase(tokenName)) {
                this.setUserName(shortname);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            UserContext.set((UserContext)old);
            throw throwable;
        }
        UserContext.set((UserContext)old);
    }

    private static final ClassLoader getPrivilegedThreadClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static final void setPrivilegedThreadClassLoader() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread.currentThread().setContextClassLoader(JAASContext.class.getClassLoader());
                return null;
            }
        });
    }

    public static void establishThreadContextClassLoader() {
        block4: {
            String m_method = "establishThreadContextClassLoader";
            try {
                ClassLoader contextClassLoader = JAASContext.getPrivilegedThreadClassLoader();
                if (contextClassLoader == null) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, "establishThreadContextClassLoader", "contextClassLoader is NULL!!!!");
                    }
                    JAASContext.setPrivilegedThreadClassLoader();
                    contextClassLoader = Thread.currentThread().getContextClassLoader();
                }
            }
            catch (Exception e) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "establishThreadContextClassLoader", e);
            }
        }
    }

    public static Subject getCurrentUserContextSubject() {
        Set<Principal> p;
        String m_method = "getCurrentUserContextSubject";
        UserContext uc = UserContext.get();
        Subject m_ucSubject = null;
        if (uc != null && (m_ucSubject = uc.getSubject()) != null && ((p = m_ucSubject.getPrincipals()) == null || p.isEmpty())) {
            Set<Object> p2;
            if (logger.isFinest()) {
                logger.finest(m_className, "getCurrentUserContextSubject", "has no Principals yet...");
            }
            if ((p2 = m_ucSubject.getPrivateCredentials()) == null || p2.isEmpty()) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "getCurrentUserContextSubject", "has no private cred either..");
                }
                m_ucSubject = null;
            }
        }
        return m_ucSubject;
    }

    public static JAASContext getJAASContext(boolean m_bNeedToLogonViaJAAS, String m_username, String m_pw, String m_cempUri, String callContext) throws VWException {
        Subject mySubject = null;
        JAASContext res = null;
        String m_method = "getJAASContext:" + callContext + ":" + m_cempUri;
        if (m_cempUri != null && m_cempUri.toLowerCase().indexOf(".dll") != -1) {
            throw new VWException("orb.session.invalidCEURI", "Invalid CE URI: {0}", m_cempUri);
        }
        try {
            if (m_bNeedToLogonViaJAAS && m_username != null && m_pw != null && m_cempUri != null) {
                JAASContext.establishThreadContextClassLoader();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Performing JAAS LoginContext.login for " + m_username + ", " + JAASContext.printPW(m_pw));
                }
                UserPasswordCallbackHandler cbh = new UserPasswordCallbackHandler(m_username, m_pw.toCharArray(), m_cempUri);
                LoginContext lc = null;
                String jaasSelector = "FileNetP8";
                if (m_cempUri.startsWith("http")) {
                    jaasSelector = "FileNetP8WSI";
                }
                for (int retryCount = 0; retryCount < 3; ++retryCount) {
                    try {
                        lc = new LoginContext(jaasSelector, cbh);
                        lc.login();
                        break;
                    }
                    catch (LoginException e) {
                        if (jaasSelector.equals("FileNetP8")) {
                            jaasSelector = "FileNetP8Engine";
                        }
                        if (!jaasSelector.equals("FileNetP8WSI")) continue;
                        jaasSelector = "FileNetP8";
                        continue;
                    }
                }
                if (lc != null) {
                    mySubject = lc.getSubject();
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Got subject via userpassword callback handler - " + jaasSelector);
                    }
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "JAAS login succeeded for " + m_username + "\nSubject = " + mySubject);
                    }
                } else if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "JAAS login FAILED for " + m_username);
                }
            } else {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Getting current JAAS Subject from CE 4.0");
                }
                if ((mySubject = JAASContext.getCurrentUserContextSubject()) == null) {
                    mySubject = J2EEUtil.getInstance().getCurrentSubject();
                }
            }
            res = new JAASContext(mySubject, m_cempUri);
            if (res.getUserName() == null || res.getUserName().length() == 0) {
                res.setUserName(m_username);
            }
            return res;
        }
        catch (Throwable t) {
            logger.throwing(m_className, m_method, t);
            logger.severe(m_className, m_method, t.getLocalizedMessage());
            throw new VWException("orb.session.FailedToCreateJAASContext", "Problem getting JAAS Context: {0}", t);
        }
    }
}

